/*****************************************************************************
 * $CAMITK_LICENCE_BEGIN$
 *
 * CamiTK - Computer Assisted Medical Intervention ToolKit
 * (c) 2001-2025 Univ. Grenoble Alpes, CNRS, Grenoble INP - UGA, TIMC, 38000 Grenoble, France
 *
 * Visit http://camitk.imag.fr for more information
 *
 * This file is part of CamiTK.
 *
 * CamiTK is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * CamiTK is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with CamiTK.  If not, see <http://www.gnu.org/licenses/>.
 *
 * $CAMITK_LICENCE_END$
 ****************************************************************************/

#include "ITKVtkGlue.h"

// Generic Filter
template class itk::VTKImageToImageFilter<itk::Image<char, 2u>>;
template class itk::VTKImageToImageFilter<itk::Image<char, 3u>>;
template class itk::CastImageFilter<itk::Image<char, 2u>, itk::Image<double, 2u>>;
template class itk::CastImageFilter<itk::Image<char, 3u>, itk::Image<double, 3u>>;
template class itk::RescaleIntensityImageFilter<itk::Image<double, 2u>, itk::Image<char, 2u>>;
template class itk::RescaleIntensityImageFilter<itk::Image<double, 3u>, itk::Image<char, 3u>>;
template class itk::ImageToVTKImageFilter<itk::Image<char, 2u>>;
template class itk::ImageToVTKImageFilter<itk::Image<char, 3u>>;

template class itk::VTKImageToImageFilter<itk::Image<unsigned char, 2u>>;
template class itk::VTKImageToImageFilter<itk::Image<unsigned char, 3u>>;
template class itk::CastImageFilter<itk::Image<unsigned char, 2u>, itk::Image<double, 2u>>;
template class itk::CastImageFilter<itk::Image<unsigned char, 3u>, itk::Image<double, 3u>>;
template class itk::RescaleIntensityImageFilter<itk::Image<double, 2u>, itk::Image<unsigned char, 2u>>;
template class itk::RescaleIntensityImageFilter<itk::Image<double, 3u>, itk::Image<unsigned char, 3u>>;
template class itk::ImageToVTKImageFilter<itk::Image<unsigned char, 2u>>;
template class itk::ImageToVTKImageFilter<itk::Image<unsigned char, 3u>>;

// templated type for signed char
template class itk::VTKImageToImageFilter<itk::Image<signed char, 2u>>;
template class itk::VTKImageToImageFilter<itk::Image<signed char, 3u>>;
template class itk::CastImageFilter<itk::Image<signed char, 2u>, itk::Image<double, 2u>>;
template class itk::CastImageFilter<itk::Image<signed char, 3u>, itk::Image<double, 3u>>;
template class itk::RescaleIntensityImageFilter<itk::Image<double, 2u>, itk::Image<signed char, 2u>>;
template class itk::RescaleIntensityImageFilter<itk::Image<double, 3u>, itk::Image<signed char, 3u>>;
template class itk::ImageToVTKImageFilter<itk::Image<signed char, 2u>>;
template class itk::ImageToVTKImageFilter<itk::Image<signed char, 3u>>;

// templated type for short
template class itk::VTKImageToImageFilter<itk::Image<short, 2u>>;
template class itk::VTKImageToImageFilter<itk::Image<short, 3u>>;
template class itk::CastImageFilter<itk::Image<short, 2u>, itk::Image<double, 2u>>;
template class itk::CastImageFilter<itk::Image<short, 3u>, itk::Image<double, 3u>>;
template class itk::RescaleIntensityImageFilter<itk::Image<double, 2u>, itk::Image<short, 2u>>;
template class itk::RescaleIntensityImageFilter<itk::Image<double, 3u>, itk::Image<short, 3u>>;
template class itk::ImageToVTKImageFilter<itk::Image<short, 2u>>;
template class itk::ImageToVTKImageFilter<itk::Image<short, 3u>>;

// templated type for unsigned short
template class itk::VTKImageToImageFilter<itk::Image<unsigned short, 2u>>;
template class itk::VTKImageToImageFilter<itk::Image<unsigned short, 3u>>;
template class itk::CastImageFilter<itk::Image<unsigned short, 2u>, itk::Image<double, 2u>>;
template class itk::CastImageFilter<itk::Image<unsigned short, 3u>, itk::Image<double, 3u>>;
template class itk::RescaleIntensityImageFilter<itk::Image<double, 2u>, itk::Image<unsigned short, 2u>>;
template class itk::RescaleIntensityImageFilter<itk::Image<double, 3u>, itk::Image<unsigned short, 3u>>;
template class itk::ImageToVTKImageFilter<itk::Image<unsigned short, 2u>>;
template class itk::ImageToVTKImageFilter<itk::Image<unsigned short, 3u>>;

// templated type for int
template class itk::VTKImageToImageFilter<itk::Image<int, 2u>>;
template class itk::VTKImageToImageFilter<itk::Image<int, 3u>>;
template class itk::CastImageFilter<itk::Image<int, 2u>, itk::Image<double, 2u>>;
template class itk::CastImageFilter<itk::Image<int, 3u>, itk::Image<double, 3u>>;
template class itk::RescaleIntensityImageFilter<itk::Image<double, 2u>, itk::Image<int, 2u>>;
template class itk::RescaleIntensityImageFilter<itk::Image<double, 3u>, itk::Image<int, 3u>>;
template class itk::ImageToVTKImageFilter<itk::Image<int, 2u>>;
template class itk::ImageToVTKImageFilter<itk::Image<int, 3u>>;

// templated type for unsigned int
template class itk::VTKImageToImageFilter<itk::Image<unsigned int, 2u>>;
template class itk::VTKImageToImageFilter<itk::Image<unsigned int, 3u>>;
template class itk::CastImageFilter<itk::Image<unsigned int, 2u>, itk::Image<double, 2u>>;
template class itk::CastImageFilter<itk::Image<unsigned int, 3u>, itk::Image<double, 3u>>;
template class itk::RescaleIntensityImageFilter<itk::Image<double, 2u>, itk::Image<unsigned int, 2u>>;
template class itk::RescaleIntensityImageFilter<itk::Image<double, 3u>, itk::Image<unsigned int, 3u>>;
template class itk::ImageToVTKImageFilter<itk::Image<unsigned int, 2u>>;
template class itk::ImageToVTKImageFilter<itk::Image<unsigned int, 3u>>;

// templated type for long
template class itk::VTKImageToImageFilter<itk::Image<long, 2u>>;
template class itk::VTKImageToImageFilter<itk::Image<long, 3u>>;
template class itk::CastImageFilter<itk::Image<long, 2u>, itk::Image<double, 2u>>;
template class itk::CastImageFilter<itk::Image<long, 3u>, itk::Image<double, 3u>>;
template class itk::RescaleIntensityImageFilter<itk::Image<double, 2u>, itk::Image<long, 2u>>;
template class itk::RescaleIntensityImageFilter<itk::Image<double, 3u>, itk::Image<long, 3u>>;
template class itk::ImageToVTKImageFilter<itk::Image<long, 2u>>;
template class itk::ImageToVTKImageFilter<itk::Image<long, 3u>>;

// templated type for unsigned long
template class itk::VTKImageToImageFilter<itk::Image<unsigned long, 2u>>;
template class itk::VTKImageToImageFilter<itk::Image<unsigned long, 3u>>;
template class itk::CastImageFilter<itk::Image<unsigned long, 2u>, itk::Image<double, 2u>>;
template class itk::CastImageFilter<itk::Image<unsigned long, 3u>, itk::Image<double, 3u>>;
template class itk::RescaleIntensityImageFilter<itk::Image<double, 2u>, itk::Image<unsigned long, 2u>>;
template class itk::RescaleIntensityImageFilter<itk::Image<double, 3u>, itk::Image<unsigned long, 3u>>;
template class itk::ImageToVTKImageFilter<itk::Image<unsigned long, 2u>>;
template class itk::ImageToVTKImageFilter<itk::Image<unsigned long, 3u>>;

// templated type for float
template class itk::VTKImageToImageFilter<itk::Image<float, 2u>>;
template class itk::VTKImageToImageFilter<itk::Image<float, 3u>>;
template class itk::CastImageFilter<itk::Image<float, 2u>, itk::Image<double, 2u>>;
template class itk::CastImageFilter<itk::Image<float, 3u>, itk::Image<double, 3u>>;
template class itk::RescaleIntensityImageFilter<itk::Image<double, 2u>, itk::Image<float, 2u>>;
template class itk::RescaleIntensityImageFilter<itk::Image<double, 3u>, itk::Image<float, 3u>>;
template class itk::ImageToVTKImageFilter<itk::Image<float, 2u>>;
template class itk::ImageToVTKImageFilter<itk::Image<float, 3u>>;

// templated type for double
template class itk::VTKImageToImageFilter<itk::Image<double, 2u>>;
template class itk::VTKImageToImageFilter<itk::Image<double, 3u>>;
template class itk::CastImageFilter<itk::Image<double, 2u>, itk::Image<double, 2u>>;
template class itk::CastImageFilter<itk::Image<double, 3u>, itk::Image<double, 3u>>;
template class itk::RescaleIntensityImageFilter<itk::Image<double, 2u>, itk::Image<double, 2u>>;
template class itk::RescaleIntensityImageFilter<itk::Image<double, 3u>, itk::Image<double, 3u>>;
template class itk::ImageToVTKImageFilter<itk::Image<double, 2u>>;
template class itk::ImageToVTKImageFilter<itk::Image<double, 3u>>;