"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.rectifyExtPrivateTable = exports.rectifyCmapTable = void 0;
const Ot = require("@ot-builder/ot");
const shared_1 = require("../shared");
function rectifyCmapTable(rec, table) {
    const newTable = new Ot.Cmap.Table();
    for (const [encoding, glyph] of table.unicode.entries()) {
        const g1 = rec.glyphRef(glyph);
        if (g1)
            newTable.unicode.set(encoding, g1);
    }
    for (const [u, s, glyph] of table.vs.entries()) {
        const g1 = rec.glyphRef(glyph);
        if (g1)
            newTable.vs.set(u, s, g1);
    }
    return newTable;
}
exports.rectifyCmapTable = rectifyCmapTable;
function rectifyExtPrivateTable(rec, table) {
    const newTable = new Ot.XPrv.Table();
    newTable.shared = table.shared;
    if (table.perGlyph) {
        newTable.perGlyph = shared_1.RectifyImpl.Glyph.mapSome(rec, table.perGlyph);
    }
    return newTable;
}
exports.rectifyExtPrivateTable = rectifyExtPrivateTable;
//# sourceMappingURL=index.js.map