"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.splitAtExtrema = void 0;
const fn_1 = require("../../fn");
const slice_arc_1 = require("../shared/slice-arc");
function splitAtExtrema(arc, sink) {
    const rs = new fn_1.RootSolver.ClampedRootSink(0, 1, false);
    arc.getXExtrema(rs);
    arc.getYExtrema(rs);
    rs.roots.sort(ascending);
    const ts = rs.roots;
    if (ts.length > 1) {
        let i = 1, j = 1;
        for (; i < ts.length; i++) {
            if (ts[i] - ts[j - 1] >= fn_1.CURVE_TIME_EPSILON)
                ts[j++] = ts[i];
        }
        ts.length = j;
    }
    if (ts.length && ts[0] < fn_1.CURVE_TIME_EPSILON) {
        ts[0] = 0;
    }
    else {
        ts.unshift(0);
    }
    if (ts.length && ts[ts.length - 1] > 1 - fn_1.CURVE_TIME_EPSILON) {
        ts[ts.length - 1] = 1;
    }
    else {
        ts.push(1);
    }
    for (let k = 1; k < ts.length; k++) {
        let slice = arc.sliceRatio(ts[k - 1], ts[k]);
        slice.cornerTypeBefore = k === 1 ? arc.cornerTypeBefore : slice_arc_1.CornerType.Extrema;
        slice.cornerTypeAfter = k === ts.length - 1 ? arc.cornerTypeAfter : slice_arc_1.CornerType.Extrema;
        sink.push(slice);
    }
}
exports.splitAtExtrema = splitAtExtrema;
function ascending(a, b) {
    return a - b;
}
