%feature("docstring") OT::WeibullMax
R"RAW(WeibullMax distribution.

Its cumulative distribution function and probability density function are defined as:

.. math::
    :nowrap:

    \begin{eqnarray*}
        F_X(x) & = &  \exp \left(-\left(-\frac{x - \gamma}{\beta}\right)^{\alpha}\right), \quad \forall x \in ( - \infty; \gamma] \\
        f_X(x) &  = & \frac{\alpha}{\beta}
             \left(-\frac{x - \gamma}{\beta} \right) ^ {\alpha-1}
             \exp \left(-\left(-\frac{x - \gamma}{\beta}\right)^{\alpha}\right),
             \quad x \in ( - \infty; \gamma]
    \end{eqnarray*}

with :math:`\beta > 0` and :math:`\alpha > 0`.
        

Its first moments are:

.. math::
    :nowrap:

    \begin{eqnarray*}
        \Expect{X} & = & \gamma - \beta \,\Gamma \left( 1 + \frac{1}{\alpha} \right) \\
        \Var{X} & = & \beta^2 \left( \Gamma  \left( 1 + \frac{2}{\alpha} \right) -
                     \Gamma^2  \left( 1 + \frac{1}{\alpha} \right) \right)
    \end{eqnarray*}

where :math:`\Gamma` denotes Euler's Gamma function
:meth:`~openturns.SpecFunc.Gamma`.

Parameters
----------
beta : float
    Scale parameter :math:`\beta > 0`.

    Default value is 1.0.
alpha : float
    Shape parameter :math:`\alpha > 0`.

    Default value is 1.0.
gamma : float, optional
    Location parameter.

    Default value is 0.0.

Notes
-----
It is possible to create a WeibullMax distribution from the alternative parametrization :math:`(\mu, \sigma, \gamma)`: see  :class:`~openturns.WeibullMaxMuSigma`. In that case, all the results are presented in that new parametrization.

In order to use the alternative  parametrization :math:`(\mu, \sigma, \gamma)` only to create the distribution, see the example below: all the results will be presented in the native parametrization :math:`(\beta, \alpha, \gamma)`.

Note that if :math:`X` follows a WeibullMax :math:`(\beta, \alpha, \gamma)` distribution, then  :math:`(-X)` follows a WeibullMin :math:`(\beta, \alpha, -\gamma)` distribution.

See also
--------
WeibullMin

Examples
--------
Create a distribution from its native parameters :math:`(\beta, \alpha, \gamma)`:

>>> import openturns as ot
>>> myDist = ot.WeibullMax(2.0, 1.5, 3.0)

Create it from the alternative parametrization :math:`(\mu, \sigma, \gamma)`:

>>> myDist2 = ot.WeibullMax()
>>> myDist2.setParameter(ot.WeibullMaxMuSigma()([2.8, 1.2, 4.6]))

Create it from :math:`(\mu, \sigma, \gamma)` and keep that parametrization for the remaining study: 

>>> myParam = ot.WeibullMaxMuSigma(2.8, 1.2, 4.6)
>>> myDist3 = ot.ParametrizedDistribution(myParam)

Draw a sample:

>>> sample = myDist.getSample(5)
)RAW"

// ---------------------------------------------------------------------

%feature("docstring") OT::WeibullMax::getAlpha
R"RAW(Accessor to the distribution's shape parameter :math:`\alpha`.

Returns
-------
alpha : float
    Shape parameter :math:`\alpha`.)RAW"

// ---------------------------------------------------------------------

%feature("docstring") OT::WeibullMax::getBeta
R"RAW(Accessor to the distribution's scale parameter :math:`\beta`.

Returns
-------
beta : float
    Scale parameter :math:`\beta`.)RAW"

// ---------------------------------------------------------------------

%feature("docstring") OT::WeibullMax::getGamma
R"RAW(Accessor to the distribution's location parameter :math:`\gamma`.

Returns
-------
gamma : float
    Location parameter :math:`\gamma`.)RAW"

// ---------------------------------------------------------------------

%feature("docstring") OT::WeibullMax::setAlpha
R"RAW(Accessor to the distribution's shape parameter :math:`\alpha`.

Parameters
----------
alpha : float, :math:`\alpha > 0`
    Shape parameter :math:`\alpha`.)RAW"

// ---------------------------------------------------------------------

%feature("docstring") OT::WeibullMax::setBeta
R"RAW(Accessor to the distribution's scale parameter :math:`\beta`.

Parameters
----------
beta : float, :math:`\beta > 0`
    Scale parameter :math:`\beta`.)RAW"

// ---------------------------------------------------------------------

%feature("docstring") OT::WeibullMax::setGamma
R"RAW(Accessor to the distribution's location parameter :math:`\gamma`.

Parameters
----------
gamma : float
    Location parameter :math:`\gamma`.)RAW"
