# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.security import SecurityCenter

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer, recorded_by_proxy

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestSecurityCenterCustomAssessmentAutomationsOperations(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(SecurityCenter)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_custom_assessment_automations_get(self, resource_group):
        response = self.client.custom_assessment_automations.get(
            resource_group_name=resource_group.name,
            custom_assessment_automation_name="str",
            api_version="2021-07-01-preview",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_custom_assessment_automations_create(self, resource_group):
        response = self.client.custom_assessment_automations.create(
            resource_group_name=resource_group.name,
            custom_assessment_automation_name="str",
            custom_assessment_automation_body={
                "compressedQuery": "str",
                "description": "str",
                "displayName": "str",
                "id": "str",
                "name": "str",
                "remediationDescription": "str",
                "severity": "Low",
                "supportedCloud": "AWS",
                "type": "str",
            },
            api_version="2021-07-01-preview",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_custom_assessment_automations_delete(self, resource_group):
        response = self.client.custom_assessment_automations.delete(
            resource_group_name=resource_group.name,
            custom_assessment_automation_name="str",
            api_version="2021-07-01-preview",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_custom_assessment_automations_list_by_resource_group(self, resource_group):
        response = self.client.custom_assessment_automations.list_by_resource_group(
            resource_group_name=resource_group.name,
            api_version="2021-07-01-preview",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_custom_assessment_automations_list_by_subscription(self, resource_group):
        response = self.client.custom_assessment_automations.list_by_subscription(
            api_version="2021-07-01-preview",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...
