# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.deviceregistry.aio import DeviceRegistryMgmtClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer
from devtools_testutils.aio import recorded_by_proxy_async

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestDeviceRegistryMgmtNamespaceDevicesOperationsAsync(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(DeviceRegistryMgmtClient, is_async=True)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_namespace_devices_get(self, resource_group):
        response = await self.client.namespace_devices.get(
            resource_group_name=resource_group.name,
            namespace_name="str",
            device_name="str",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_namespace_devices_begin_create_or_replace(self, resource_group):
        response = await (
            await self.client.namespace_devices.begin_create_or_replace(
                resource_group_name=resource_group.name,
                namespace_name="str",
                device_name="str",
                resource={
                    "location": "str",
                    "etag": "str",
                    "extendedLocation": {"name": "str", "type": "str"},
                    "id": "str",
                    "name": "str",
                    "properties": {
                        "attributes": {"str": {}},
                        "discoveredDeviceRef": "str",
                        "enabled": bool,
                        "endpoints": {
                            "inbound": {
                                "str": {
                                    "address": "str",
                                    "endpointType": "str",
                                    "additionalConfiguration": "str",
                                    "authentication": {
                                        "method": "str",
                                        "usernamePasswordCredentials": {
                                            "passwordSecretName": "str",
                                            "usernameSecretName": "str",
                                        },
                                        "x509Credentials": {
                                            "certificateSecretName": "str",
                                            "intermediateCertificatesSecretName": "str",
                                            "keySecretName": "str",
                                        },
                                    },
                                    "trustSettings": {"trustList": "str"},
                                    "version": "str",
                                }
                            },
                            "outbound": {
                                "assigned": {"str": {"address": "str", "endpointType": "str"}},
                                "unassigned": {"str": {"address": "str", "endpointType": "str"}},
                            },
                        },
                        "externalDeviceId": "str",
                        "lastTransitionTime": "2020-02-20 00:00:00",
                        "manufacturer": "str",
                        "model": "str",
                        "operatingSystem": "str",
                        "operatingSystemVersion": "str",
                        "provisioningState": "str",
                        "status": {
                            "config": {
                                "error": {
                                    "code": "str",
                                    "details": [
                                        {"code": "str", "correlationId": "str", "info": "str", "message": "str"}
                                    ],
                                    "message": "str",
                                },
                                "lastTransitionTime": "2020-02-20 00:00:00",
                                "version": 0,
                            },
                            "endpoints": {
                                "inbound": {
                                    "str": {
                                        "error": {
                                            "code": "str",
                                            "details": [
                                                {"code": "str", "correlationId": "str", "info": "str", "message": "str"}
                                            ],
                                            "message": "str",
                                        }
                                    }
                                }
                            },
                        },
                        "uuid": "str",
                        "version": 0,
                    },
                    "systemData": {
                        "createdAt": "2020-02-20 00:00:00",
                        "createdBy": "str",
                        "createdByType": "str",
                        "lastModifiedAt": "2020-02-20 00:00:00",
                        "lastModifiedBy": "str",
                        "lastModifiedByType": "str",
                    },
                    "tags": {"str": "str"},
                    "type": "str",
                },
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_namespace_devices_begin_update(self, resource_group):
        response = await (
            await self.client.namespace_devices.begin_update(
                resource_group_name=resource_group.name,
                namespace_name="str",
                device_name="str",
                properties={
                    "properties": {
                        "attributes": {"str": {}},
                        "enabled": bool,
                        "endpoints": {
                            "inbound": {
                                "str": {
                                    "address": "str",
                                    "endpointType": "str",
                                    "additionalConfiguration": "str",
                                    "authentication": {
                                        "method": "str",
                                        "usernamePasswordCredentials": {
                                            "passwordSecretName": "str",
                                            "usernameSecretName": "str",
                                        },
                                        "x509Credentials": {
                                            "certificateSecretName": "str",
                                            "intermediateCertificatesSecretName": "str",
                                            "keySecretName": "str",
                                        },
                                    },
                                    "trustSettings": {"trustList": "str"},
                                    "version": "str",
                                }
                            },
                            "outbound": {
                                "assigned": {"str": {"address": "str", "endpointType": "str"}},
                                "unassigned": {"str": {"address": "str", "endpointType": "str"}},
                            },
                        },
                        "operatingSystemVersion": "str",
                    },
                    "tags": {"str": "str"},
                },
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_namespace_devices_begin_delete(self, resource_group):
        response = await (
            await self.client.namespace_devices.begin_delete(
                resource_group_name=resource_group.name,
                namespace_name="str",
                device_name="str",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_namespace_devices_list_by_resource_group(self, resource_group):
        response = self.client.namespace_devices.list_by_resource_group(
            resource_group_name=resource_group.name,
            namespace_name="str",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...
