% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dist_categorical.R
\name{dist_categorical}
\alias{dist_categorical}
\title{The Categorical distribution}
\usage{
dist_categorical(prob, outcomes = NULL)
}
\arguments{
\item{prob}{A list of probabilities of observing each outcome category.}

\item{outcomes}{The list of vectors where each value represents each outcome.}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

Categorical distributions are used to represent events with multiple
outcomes, such as what number appears on the roll of a dice. This is also
referred to as the 'generalised Bernoulli' or 'multinoulli' distribution.
The Categorical distribution is a special case of the \code{\link[=Multinomial]{Multinomial()}}
distribution with \code{n = 1}.
}
\details{
We recommend reading this documentation on \href{https://pkg.mitchelloharawild.com/distributional/reference/dist_categorical.html}{pkgdown} which renders math nicely.
\url{https://pkg.mitchelloharawild.com/distributional/reference/dist_categorical.html}

In the following, let \eqn{X} be a Categorical random variable with
probability parameters \code{prob} = \eqn{\{p_1, p_2, \ldots, p_k\}}.

The Categorical probability distribution is widely used to model the
occurance of multiple events. A simple example is the roll of a dice, where
\eqn{p = \{1/6, 1/6, 1/6, 1/6, 1/6, 1/6\}} giving equal chance of observing
each number on a 6 sided dice.

\strong{Support}: \eqn{\{1, \ldots, k\}}{{1, ..., k}}

\strong{Mean}: Not defined for unordered categories. For ordered categories with
integer outcomes \eqn{\{1, 2, \ldots, k\}}, the mean is:

\deqn{
    E(X) = \sum_{i=1}^{k} i \cdot p_i
  }{
    E(X) = sum(i * p_i) for i = 1 to k
  }

\strong{Variance}: Not defined for unordered categories. For ordered categories
with integer outcomes \eqn{\{1, 2, \ldots, k\}}, the variance is:

\deqn{
    \text{Var}(X) = \sum_{i=1}^{k} i^2 \cdot p_i - \left(\sum_{i=1}^{k} i \cdot p_i\right)^2
  }{
    Var(X) = sum(i^2 * p_i) - [sum(i * p_i)]^2
  }

\strong{Probability mass function (p.m.f)}:

\deqn{
    P(X = i) = p_i
  }{
    P(X = i) = p_i
  }

\strong{Cumulative distribution function (c.d.f)}:

The c.d.f is undefined for unordered categories. For ordered categories
with outcomes \eqn{x_1 < x_2 < \ldots < x_k}, the c.d.f is:

\deqn{
    P(X \le x_j) = \sum_{i=1}^{j} p_i
  }{
    P(X <= x_j) = sum(p_i) for i = 1 to j
  }

\strong{Moment generating function (m.g.f)}:

\deqn{
    E(e^{tX}) = \sum_{i=1}^{k} e^{tx_i} \cdot p_i
  }{
    E(e^(tX)) = sum(e^(t * x_i) * p_i) for i = 1 to k
  }

\strong{Skewness}: Approximated numerically for ordered categories.

\strong{Kurtosis}: Approximated numerically for ordered categories.
}
\examples{
dist <- dist_categorical(prob = list(c(0.05, 0.5, 0.15, 0.2, 0.1), c(0.3, 0.1, 0.6)))

dist

generate(dist, 10)

density(dist, 2)
density(dist, 2, log = TRUE)

# The outcomes aren't ordered, so many statistics are not applicable.
cdf(dist, 0.6)
quantile(dist, 0.7)
mean(dist)
variance(dist)
skewness(dist)
kurtosis(dist)

# Some of these statistics are meaningful for ordered outcomes
dist <- dist_categorical(list(rpois(26, 3)), list(ordered(letters)))
dist
cdf(dist, "m")
quantile(dist, 0.5)

dist <- dist_categorical(
  prob = list(c(0.05, 0.5, 0.15, 0.2, 0.1), c(0.3, 0.1, 0.6)),
  outcomes = list(letters[1:5], letters[24:26])
)

generate(dist, 10)

density(dist, "a")
density(dist, "z", log = TRUE)

}
\seealso{
\link[stats:Multinom]{stats::Multinomial}
}
