% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/discrete-d3.R
\name{scale_color_d3}
\alias{scale_color_d3}
\alias{scale_colour_d3}
\alias{scale_fill_d3}
\title{D3.js color scales}
\usage{
scale_color_d3(
  palette = c("category10", "category20", "category20b", "category20c"),
  alpha = 1,
  ...
)

scale_colour_d3(
  palette = c("category10", "category20", "category20b", "category20c"),
  alpha = 1,
  ...
)

scale_fill_d3(
  palette = c("category10", "category20", "category20b", "category20c"),
  alpha = 1,
  ...
)
}
\arguments{
\item{palette}{Palette type. There are four available options:
\itemize{
\item \code{"category10"} (10-color palette).
\item \code{"category20"} (20-color palette).
\item \code{"category20b"} (20-color palette).
\item \code{"category20c"} (20-color palette).
}}

\item{alpha}{Transparency level, a real number in (0, 1].
See \code{alpha} in \code{\link[grDevices:rgb]{grDevices::rgb()}} for details.}

\item{...}{Additional parameters for \code{\link[ggplot2:discrete_scale]{ggplot2::discrete_scale()}}.}
}
\description{
See \code{\link[=pal_d3]{pal_d3()}} for details.
}
\examples{
p1 <- example_scatterplot()
p2 <- example_barplot()

p1 + scale_color_d3()
p2 + scale_fill_d3()

p1 + scale_color_d3(palette = "category20")
p2 + scale_fill_d3(palette = "category20")

p1 + scale_color_d3(palette = "category20b")
p2 + scale_fill_d3(palette = "category20b")

p1 + scale_color_d3(palette = "category20c")
p2 + scale_fill_d3(palette = "category20c")
}
\references{
\url{https://github.com/d3/d3-3.x-api-reference/blob/master/Ordinal-Scales.md}
}
\author{
Nan Xiao | \email{me@nanx.me} | \url{https://nanx.me}
}
