# SPDX-License-Identifier: BSD-3-Clause
#
# Copyright 2025 Raritan Inc. All rights reserved.
#
# This is an auto-generated file.

#
# Section generated by IdlC from "DoorAccessControl.idl"
#

import raritan.rpc
from raritan.rpc import Interface, Structure, ValueObject, Enumeration, typecheck, DecodeException
import raritan.rpc.event

import raritan.rpc.idl

import raritan.rpc.peripheral

import raritan.rpc.smartlock


# interface
class DoorAccessControl(Interface):
    idlType = "smartlock.DoorAccessControl:1.2.4"

    ERR_INVALID_SETTINGS = 1

    ERR_NO_SUCH_ID = 2

    ERR_MAX_RULES_REACHED = 3

    # structure
    class AbsoluteTimeCondition(Structure):
        idlType = "smartlock.DoorAccessControl_1_2_4.AbsoluteTimeCondition:1.0.0"
        elements = ["enabled", "validFrom", "validTill"]

        def __init__(self, enabled=False, validFrom=None, validTill=None):
            typecheck.is_bool(enabled, AssertionError)
            typecheck.is_time(validFrom, AssertionError)
            typecheck.is_time(validTill, AssertionError)

            self.enabled = enabled
            self.validFrom = validFrom
            self.validTill = validTill

        @classmethod
        def decode(cls, json, agent, useDefaults=False):
            obj = cls(
                enabled = json['enabled'] if 'enabled' in json or not useDefaults else False,
                validFrom = raritan.rpc.Time.decode(json['validFrom']) if 'validFrom' in json or not useDefaults else None,
                validTill = raritan.rpc.Time.decode(json['validTill']) if 'validTill' in json or not useDefaults else None,
            )
            return obj

        def encode(self):
            json = {}
            json['enabled'] = self.enabled
            json['validFrom'] = raritan.rpc.Time.encode(self.validFrom)
            json['validTill'] = raritan.rpc.Time.encode(self.validTill)
            return json

    # structure
    class PeriodicTimeCondition(Structure):
        idlType = "smartlock.DoorAccessControl_1_2_4.PeriodicTimeCondition:1.0.0"
        elements = ["enabled", "daysOfWeek", "fromHourOfDay", "tillHourOfDay", "fromMinuteOfHour", "tillMinuteOfHour"]

        def __init__(self, enabled=False, daysOfWeek=[], fromHourOfDay=0, tillHourOfDay=0, fromMinuteOfHour=0, tillMinuteOfHour=0):
            typecheck.is_bool(enabled, AssertionError)
            for x0 in daysOfWeek:
                typecheck.is_int(x0, AssertionError)
            typecheck.is_int(fromHourOfDay, AssertionError)
            typecheck.is_int(tillHourOfDay, AssertionError)
            typecheck.is_int(fromMinuteOfHour, AssertionError)
            typecheck.is_int(tillMinuteOfHour, AssertionError)

            self.enabled = enabled
            self.daysOfWeek = daysOfWeek
            self.fromHourOfDay = fromHourOfDay
            self.tillHourOfDay = tillHourOfDay
            self.fromMinuteOfHour = fromMinuteOfHour
            self.tillMinuteOfHour = tillMinuteOfHour

        @classmethod
        def decode(cls, json, agent, useDefaults=False):
            obj = cls(
                enabled = json['enabled'] if 'enabled' in json or not useDefaults else False,
                daysOfWeek = [x0 for x0 in json['daysOfWeek']] if 'daysOfWeek' in json or not useDefaults else [],
                fromHourOfDay = json['fromHourOfDay'] if 'fromHourOfDay' in json or not useDefaults else 0,
                tillHourOfDay = json['tillHourOfDay'] if 'tillHourOfDay' in json or not useDefaults else 0,
                fromMinuteOfHour = json['fromMinuteOfHour'] if 'fromMinuteOfHour' in json or not useDefaults else 0,
                tillMinuteOfHour = json['tillMinuteOfHour'] if 'tillMinuteOfHour' in json or not useDefaults else 0,
            )
            return obj

        def encode(self):
            json = {}
            json['enabled'] = self.enabled
            json['daysOfWeek'] = [x0 for x0 in self.daysOfWeek]
            json['fromHourOfDay'] = self.fromHourOfDay
            json['tillHourOfDay'] = self.tillHourOfDay
            json['fromMinuteOfHour'] = self.fromMinuteOfHour
            json['tillMinuteOfHour'] = self.tillMinuteOfHour
            return json

    # structure
    class CardReaderInfo(Structure):
        idlType = "smartlock.DoorAccessControl_1_2_4.CardReaderInfo:1.0.0"
        elements = ["linkId", "position"]

        def __init__(self, linkId=0, position=""):
            typecheck.is_int(linkId, AssertionError)
            if not typecheck._is_int(position):
                typecheck.is_string(position, AssertionError)

            self.linkId = linkId
            self.position = position

        @classmethod
        def decode(cls, json, agent, useDefaults=False):
            obj = cls(
                linkId = json['linkId'] if 'linkId' in json or not useDefaults else 0,
                position = json['position'] if 'position' in json or not useDefaults else "",
            )
            return obj

        def encode(self):
            json = {}
            json['linkId'] = self.linkId
            json['position'] = str(self.position)
            return json

    # structure
    class KeypadInfo(Structure):
        idlType = "smartlock.DoorAccessControl_1_2_4.KeypadInfo:1.0.0"
        elements = ["linkId", "position"]

        def __init__(self, linkId=0, position=""):
            typecheck.is_int(linkId, AssertionError)
            if not typecheck._is_int(position):
                typecheck.is_string(position, AssertionError)

            self.linkId = linkId
            self.position = position

        @classmethod
        def decode(cls, json, agent, useDefaults=False):
            obj = cls(
                linkId = json['linkId'] if 'linkId' in json or not useDefaults else 0,
                position = json['position'] if 'position' in json or not useDefaults else "",
            )
            return obj

        def encode(self):
            json = {}
            json['linkId'] = self.linkId
            json['position'] = str(self.position)
            return json

    # structure
    class CardCondition(Structure):
        idlType = "smartlock.DoorAccessControl_1_2_4.CardCondition:1.0.0"
        elements = ["enabled", "cardUid", "cardReader"]

        def __init__(self, enabled=False, cardUid="", cardReader=None):
            if cardReader is None:
                cardReader = raritan.rpc.smartlock.DoorAccessControl.CardReaderInfo()
            typecheck.is_bool(enabled, AssertionError)
            if not typecheck._is_int(cardUid):
                typecheck.is_string(cardUid, AssertionError)
            typecheck.is_struct(cardReader, raritan.rpc.smartlock.DoorAccessControl.CardReaderInfo, AssertionError)

            self.enabled = enabled
            self.cardUid = cardUid
            self.cardReader = cardReader

        @classmethod
        def decode(cls, json, agent, useDefaults=False):
            obj = cls(
                enabled = json['enabled'] if 'enabled' in json or not useDefaults else False,
                cardUid = json['cardUid'] if 'cardUid' in json or not useDefaults else "",
                cardReader = raritan.rpc.smartlock.DoorAccessControl.CardReaderInfo.decode(json['cardReader'], agent, useDefaults=useDefaults) if 'cardReader' in json or not useDefaults else raritan.rpc.smartlock.DoorAccessControl.CardReaderInfo(),
            )
            return obj

        def encode(self):
            json = {}
            json['enabled'] = self.enabled
            json['cardUid'] = str(self.cardUid)
            json['cardReader'] = raritan.rpc.smartlock.DoorAccessControl.CardReaderInfo.encode(self.cardReader)
            return json

    # structure
    class KeypadCondition(Structure):
        idlType = "smartlock.DoorAccessControl_1_2_4.KeypadCondition:1.0.0"
        elements = ["enabled", "pin", "keypad"]

        def __init__(self, enabled=False, pin="", keypad=None):
            if keypad is None:
                keypad = raritan.rpc.smartlock.DoorAccessControl.KeypadInfo()
            typecheck.is_bool(enabled, AssertionError)
            if not typecheck._is_int(pin):
                typecheck.is_string(pin, AssertionError)
            typecheck.is_struct(keypad, raritan.rpc.smartlock.DoorAccessControl.KeypadInfo, AssertionError)

            self.enabled = enabled
            self.pin = pin
            self.keypad = keypad

        @classmethod
        def decode(cls, json, agent, useDefaults=False):
            obj = cls(
                enabled = json['enabled'] if 'enabled' in json or not useDefaults else False,
                pin = json['pin'] if 'pin' in json or not useDefaults else "",
                keypad = raritan.rpc.smartlock.DoorAccessControl.KeypadInfo.decode(json['keypad'], agent, useDefaults=useDefaults) if 'keypad' in json or not useDefaults else raritan.rpc.smartlock.DoorAccessControl.KeypadInfo(),
            )
            return obj

        def encode(self):
            json = {}
            json['enabled'] = self.enabled
            json['pin'] = str(self.pin)
            json['keypad'] = raritan.rpc.smartlock.DoorAccessControl.KeypadInfo.encode(self.keypad)
            return json

    # structure
    class DoorAccessRule(Structure):
        idlType = "smartlock.DoorAccessControl_1_2_4.DoorAccessRule:1.0.0"
        elements = ["name", "doorHandleLocks", "cardCondition1", "cardCondition2", "keypadCondition1", "keypadCondition2", "conditionsTimeout", "absoluteTime", "periodicTime"]

        def __init__(self, name="", doorHandleLocks=[], cardCondition1=None, cardCondition2=None, keypadCondition1=None, keypadCondition2=None, conditionsTimeout=0, absoluteTime=None, periodicTime=None):
            if cardCondition1 is None:
                cardCondition1 = raritan.rpc.smartlock.DoorAccessControl.CardCondition()
            if cardCondition2 is None:
                cardCondition2 = raritan.rpc.smartlock.DoorAccessControl.CardCondition()
            if keypadCondition1 is None:
                keypadCondition1 = raritan.rpc.smartlock.DoorAccessControl.KeypadCondition()
            if keypadCondition2 is None:
                keypadCondition2 = raritan.rpc.smartlock.DoorAccessControl.KeypadCondition()
            if absoluteTime is None:
                absoluteTime = raritan.rpc.smartlock.DoorAccessControl.AbsoluteTimeCondition()
            if periodicTime is None:
                periodicTime = raritan.rpc.smartlock.DoorAccessControl.PeriodicTimeCondition()
            if not typecheck._is_int(name):
                typecheck.is_string(name, AssertionError)
            for x0 in doorHandleLocks:
                typecheck.is_interface(x0, raritan.rpc.peripheral.DeviceSlot, AssertionError)
            typecheck.is_struct(cardCondition1, raritan.rpc.smartlock.DoorAccessControl.CardCondition, AssertionError)
            typecheck.is_struct(cardCondition2, raritan.rpc.smartlock.DoorAccessControl.CardCondition, AssertionError)
            typecheck.is_struct(keypadCondition1, raritan.rpc.smartlock.DoorAccessControl.KeypadCondition, AssertionError)
            typecheck.is_struct(keypadCondition2, raritan.rpc.smartlock.DoorAccessControl.KeypadCondition, AssertionError)
            typecheck.is_int(conditionsTimeout, AssertionError)
            typecheck.is_struct(absoluteTime, raritan.rpc.smartlock.DoorAccessControl.AbsoluteTimeCondition, AssertionError)
            typecheck.is_struct(periodicTime, raritan.rpc.smartlock.DoorAccessControl.PeriodicTimeCondition, AssertionError)

            self.name = name
            self.doorHandleLocks = doorHandleLocks
            self.cardCondition1 = cardCondition1
            self.cardCondition2 = cardCondition2
            self.keypadCondition1 = keypadCondition1
            self.keypadCondition2 = keypadCondition2
            self.conditionsTimeout = conditionsTimeout
            self.absoluteTime = absoluteTime
            self.periodicTime = periodicTime

        @classmethod
        def decode(cls, json, agent, useDefaults=False):
            obj = cls(
                name = json['name'] if 'name' in json or not useDefaults else "",
                doorHandleLocks = [Interface.decode(x0, agent) for x0 in json['doorHandleLocks']] if 'doorHandleLocks' in json or not useDefaults else [],
                cardCondition1 = raritan.rpc.smartlock.DoorAccessControl.CardCondition.decode(json['cardCondition1'], agent, useDefaults=useDefaults) if 'cardCondition1' in json or not useDefaults else raritan.rpc.smartlock.DoorAccessControl.CardCondition(),
                cardCondition2 = raritan.rpc.smartlock.DoorAccessControl.CardCondition.decode(json['cardCondition2'], agent, useDefaults=useDefaults) if 'cardCondition2' in json or not useDefaults else raritan.rpc.smartlock.DoorAccessControl.CardCondition(),
                keypadCondition1 = raritan.rpc.smartlock.DoorAccessControl.KeypadCondition.decode(json['keypadCondition1'], agent, useDefaults=useDefaults) if 'keypadCondition1' in json or not useDefaults else raritan.rpc.smartlock.DoorAccessControl.KeypadCondition(),
                keypadCondition2 = raritan.rpc.smartlock.DoorAccessControl.KeypadCondition.decode(json['keypadCondition2'], agent, useDefaults=useDefaults) if 'keypadCondition2' in json or not useDefaults else raritan.rpc.smartlock.DoorAccessControl.KeypadCondition(),
                conditionsTimeout = json['conditionsTimeout'] if 'conditionsTimeout' in json or not useDefaults else 0,
                absoluteTime = raritan.rpc.smartlock.DoorAccessControl.AbsoluteTimeCondition.decode(json['absoluteTime'], agent, useDefaults=useDefaults) if 'absoluteTime' in json or not useDefaults else raritan.rpc.smartlock.DoorAccessControl.AbsoluteTimeCondition(),
                periodicTime = raritan.rpc.smartlock.DoorAccessControl.PeriodicTimeCondition.decode(json['periodicTime'], agent, useDefaults=useDefaults) if 'periodicTime' in json or not useDefaults else raritan.rpc.smartlock.DoorAccessControl.PeriodicTimeCondition(),
            )
            return obj

        def encode(self):
            json = {}
            json['name'] = str(self.name)
            json['doorHandleLocks'] = [Interface.encode(x0) for x0 in self.doorHandleLocks]
            json['cardCondition1'] = raritan.rpc.smartlock.DoorAccessControl.CardCondition.encode(self.cardCondition1)
            json['cardCondition2'] = raritan.rpc.smartlock.DoorAccessControl.CardCondition.encode(self.cardCondition2)
            json['keypadCondition1'] = raritan.rpc.smartlock.DoorAccessControl.KeypadCondition.encode(self.keypadCondition1)
            json['keypadCondition2'] = raritan.rpc.smartlock.DoorAccessControl.KeypadCondition.encode(self.keypadCondition2)
            json['conditionsTimeout'] = self.conditionsTimeout
            json['absoluteTime'] = raritan.rpc.smartlock.DoorAccessControl.AbsoluteTimeCondition.encode(self.absoluteTime)
            json['periodicTime'] = raritan.rpc.smartlock.DoorAccessControl.PeriodicTimeCondition.encode(self.periodicTime)
            return json

    # enumeration
    class DoorAccessDenialReason(Enumeration):
        idlType = "smartlock.DoorAccessControl_1_2_4.DoorAccessDenialReason:1.0.0"
        values = ["DENIED_NO_MATCHING_RULE", "DENIED_ABSOLUTE_TIME_CONDITION", "DENIED_PERIODIC_TIME_CONDITION", "DENIED_CONDITIONS_TIMEOUT"]

    DoorAccessDenialReason.DENIED_NO_MATCHING_RULE = DoorAccessDenialReason(0)
    DoorAccessDenialReason.DENIED_ABSOLUTE_TIME_CONDITION = DoorAccessDenialReason(1)
    DoorAccessDenialReason.DENIED_PERIODIC_TIME_CONDITION = DoorAccessDenialReason(2)
    DoorAccessDenialReason.DENIED_CONDITIONS_TIMEOUT = DoorAccessDenialReason(3)

    # value object
    class DoorAccessGrantedEvent(raritan.rpc.idl.Event):
        idlType = "smartlock.DoorAccessControl_1_2_4.DoorAccessGrantedEvent:1.0.0"

        def __init__(self, ruleId=0, rule=None, source=None):
            super(raritan.rpc.smartlock.DoorAccessControl.DoorAccessGrantedEvent, self).__init__(source)
            if rule is None:
                rule = raritan.rpc.smartlock.DoorAccessControl.DoorAccessRule()
            typecheck.is_int(ruleId, AssertionError)
            typecheck.is_struct(rule, raritan.rpc.smartlock.DoorAccessControl.DoorAccessRule, AssertionError)

            self.ruleId = ruleId
            self.rule = rule

        def encode(self):
            json = super(raritan.rpc.smartlock.DoorAccessControl.DoorAccessGrantedEvent, self).encode()
            json['ruleId'] = self.ruleId
            json['rule'] = raritan.rpc.smartlock.DoorAccessControl.DoorAccessRule.encode(self.rule)
            return json

        @classmethod
        def decode(cls, json, agent, useDefaults=False):
            obj = cls(
                ruleId = json['ruleId'] if 'ruleId' in json or not useDefaults else 0,
                rule = raritan.rpc.smartlock.DoorAccessControl.DoorAccessRule.decode(json['rule'], agent, useDefaults=useDefaults) if 'rule' in json or not useDefaults else raritan.rpc.smartlock.DoorAccessControl.DoorAccessRule(),
                # for idl.Event
                source = Interface.decode(json['source'], agent) if 'source' in json or not useDefaults else None,
            )
            return obj

        def listElements(self):
            elements = ["ruleId", "rule"]
            elements = elements + super(raritan.rpc.smartlock.DoorAccessControl.DoorAccessGrantedEvent, self).listElements()
            return elements

    # value object
    class DoorAccessDeniedEvent(raritan.rpc.idl.Event):
        idlType = "smartlock.DoorAccessControl_1_2_4.DoorAccessDeniedEvent:1.0.0"

        def __init__(self, reason=None, ruleId=0, ruleName="", source=None):
            super(raritan.rpc.smartlock.DoorAccessControl.DoorAccessDeniedEvent, self).__init__(source)
            if reason is None:
                reason = raritan.rpc.smartlock.DoorAccessControl.DoorAccessDenialReason.DENIED_NO_MATCHING_RULE
            typecheck.is_enum(reason, raritan.rpc.smartlock.DoorAccessControl.DoorAccessDenialReason, AssertionError)
            typecheck.is_int(ruleId, AssertionError)
            if not typecheck._is_int(ruleName):
                typecheck.is_string(ruleName, AssertionError)

            self.reason = reason
            self.ruleId = ruleId
            self.ruleName = ruleName

        def encode(self):
            json = super(raritan.rpc.smartlock.DoorAccessControl.DoorAccessDeniedEvent, self).encode()
            json['reason'] = raritan.rpc.smartlock.DoorAccessControl.DoorAccessDenialReason.encode(self.reason)
            json['ruleId'] = self.ruleId
            json['ruleName'] = str(self.ruleName)
            return json

        @classmethod
        def decode(cls, json, agent, useDefaults=False):
            obj = cls(
                reason = raritan.rpc.smartlock.DoorAccessControl.DoorAccessDenialReason.decode(json['reason']) if 'reason' in json or not useDefaults else raritan.rpc.smartlock.DoorAccessControl.DoorAccessDenialReason.DENIED_NO_MATCHING_RULE,
                ruleId = json['ruleId'] if 'ruleId' in json or not useDefaults else 0,
                ruleName = json['ruleName'] if 'ruleName' in json or not useDefaults else "",
                # for idl.Event
                source = Interface.decode(json['source'], agent) if 'source' in json or not useDefaults else None,
            )
            return obj

        def listElements(self):
            elements = ["reason", "ruleId", "ruleName"]
            elements = elements + super(raritan.rpc.smartlock.DoorAccessControl.DoorAccessDeniedEvent, self).listElements()
            return elements

    # value object
    class DoorAccessRuleAddedEvent(raritan.rpc.event.UserEvent):
        idlType = "smartlock.DoorAccessControl_1_2_4.DoorAccessRuleAddedEvent:1.0.0"

        def __init__(self, ruleId=0, rule=None, actUserName="", actIpAddr="", source=None):
            super(raritan.rpc.smartlock.DoorAccessControl.DoorAccessRuleAddedEvent, self).__init__(actUserName, actIpAddr, source)
            if rule is None:
                rule = raritan.rpc.smartlock.DoorAccessControl.DoorAccessRule()
            typecheck.is_int(ruleId, AssertionError)
            typecheck.is_struct(rule, raritan.rpc.smartlock.DoorAccessControl.DoorAccessRule, AssertionError)

            self.ruleId = ruleId
            self.rule = rule

        def encode(self):
            json = super(raritan.rpc.smartlock.DoorAccessControl.DoorAccessRuleAddedEvent, self).encode()
            json['ruleId'] = self.ruleId
            json['rule'] = raritan.rpc.smartlock.DoorAccessControl.DoorAccessRule.encode(self.rule)
            return json

        @classmethod
        def decode(cls, json, agent, useDefaults=False):
            obj = cls(
                ruleId = json['ruleId'] if 'ruleId' in json or not useDefaults else 0,
                rule = raritan.rpc.smartlock.DoorAccessControl.DoorAccessRule.decode(json['rule'], agent, useDefaults=useDefaults) if 'rule' in json or not useDefaults else raritan.rpc.smartlock.DoorAccessControl.DoorAccessRule(),
                # for event.UserEvent
                actUserName = json['actUserName'] if 'actUserName' in json or not useDefaults else "",
                actIpAddr = json['actIpAddr'] if 'actIpAddr' in json or not useDefaults else "",
                # for idl.Event
                source = Interface.decode(json['source'], agent) if 'source' in json or not useDefaults else None,
            )
            return obj

        def listElements(self):
            elements = ["ruleId", "rule"]
            elements = elements + super(raritan.rpc.smartlock.DoorAccessControl.DoorAccessRuleAddedEvent, self).listElements()
            return elements

    # value object
    class DoorAccessRuleChangedEvent(raritan.rpc.event.UserEvent):
        idlType = "smartlock.DoorAccessControl_1_2_4.DoorAccessRuleChangedEvent:1.0.0"

        def __init__(self, ruleId=0, oldRule=None, newRule=None, actUserName="", actIpAddr="", source=None):
            super(raritan.rpc.smartlock.DoorAccessControl.DoorAccessRuleChangedEvent, self).__init__(actUserName, actIpAddr, source)
            if oldRule is None:
                oldRule = raritan.rpc.smartlock.DoorAccessControl.DoorAccessRule()
            if newRule is None:
                newRule = raritan.rpc.smartlock.DoorAccessControl.DoorAccessRule()
            typecheck.is_int(ruleId, AssertionError)
            typecheck.is_struct(oldRule, raritan.rpc.smartlock.DoorAccessControl.DoorAccessRule, AssertionError)
            typecheck.is_struct(newRule, raritan.rpc.smartlock.DoorAccessControl.DoorAccessRule, AssertionError)

            self.ruleId = ruleId
            self.oldRule = oldRule
            self.newRule = newRule

        def encode(self):
            json = super(raritan.rpc.smartlock.DoorAccessControl.DoorAccessRuleChangedEvent, self).encode()
            json['ruleId'] = self.ruleId
            json['oldRule'] = raritan.rpc.smartlock.DoorAccessControl.DoorAccessRule.encode(self.oldRule)
            json['newRule'] = raritan.rpc.smartlock.DoorAccessControl.DoorAccessRule.encode(self.newRule)
            return json

        @classmethod
        def decode(cls, json, agent, useDefaults=False):
            obj = cls(
                ruleId = json['ruleId'] if 'ruleId' in json or not useDefaults else 0,
                oldRule = raritan.rpc.smartlock.DoorAccessControl.DoorAccessRule.decode(json['oldRule'], agent, useDefaults=useDefaults) if 'oldRule' in json or not useDefaults else raritan.rpc.smartlock.DoorAccessControl.DoorAccessRule(),
                newRule = raritan.rpc.smartlock.DoorAccessControl.DoorAccessRule.decode(json['newRule'], agent, useDefaults=useDefaults) if 'newRule' in json or not useDefaults else raritan.rpc.smartlock.DoorAccessControl.DoorAccessRule(),
                # for event.UserEvent
                actUserName = json['actUserName'] if 'actUserName' in json or not useDefaults else "",
                actIpAddr = json['actIpAddr'] if 'actIpAddr' in json or not useDefaults else "",
                # for idl.Event
                source = Interface.decode(json['source'], agent) if 'source' in json or not useDefaults else None,
            )
            return obj

        def listElements(self):
            elements = ["ruleId", "oldRule", "newRule"]
            elements = elements + super(raritan.rpc.smartlock.DoorAccessControl.DoorAccessRuleChangedEvent, self).listElements()
            return elements

    # value object
    class DoorAccessRuleDeletedEvent(raritan.rpc.event.UserEvent):
        idlType = "smartlock.DoorAccessControl_1_2_4.DoorAccessRuleDeletedEvent:1.0.0"

        def __init__(self, ruleId=0, rule=None, actUserName="", actIpAddr="", source=None):
            super(raritan.rpc.smartlock.DoorAccessControl.DoorAccessRuleDeletedEvent, self).__init__(actUserName, actIpAddr, source)
            if rule is None:
                rule = raritan.rpc.smartlock.DoorAccessControl.DoorAccessRule()
            typecheck.is_int(ruleId, AssertionError)
            typecheck.is_struct(rule, raritan.rpc.smartlock.DoorAccessControl.DoorAccessRule, AssertionError)

            self.ruleId = ruleId
            self.rule = rule

        def encode(self):
            json = super(raritan.rpc.smartlock.DoorAccessControl.DoorAccessRuleDeletedEvent, self).encode()
            json['ruleId'] = self.ruleId
            json['rule'] = raritan.rpc.smartlock.DoorAccessControl.DoorAccessRule.encode(self.rule)
            return json

        @classmethod
        def decode(cls, json, agent, useDefaults=False):
            obj = cls(
                ruleId = json['ruleId'] if 'ruleId' in json or not useDefaults else 0,
                rule = raritan.rpc.smartlock.DoorAccessControl.DoorAccessRule.decode(json['rule'], agent, useDefaults=useDefaults) if 'rule' in json or not useDefaults else raritan.rpc.smartlock.DoorAccessControl.DoorAccessRule(),
                # for event.UserEvent
                actUserName = json['actUserName'] if 'actUserName' in json or not useDefaults else "",
                actIpAddr = json['actIpAddr'] if 'actIpAddr' in json or not useDefaults else "",
                # for idl.Event
                source = Interface.decode(json['source'], agent) if 'source' in json or not useDefaults else None,
            )
            return obj

        def listElements(self):
            elements = ["ruleId", "rule"]
            elements = elements + super(raritan.rpc.smartlock.DoorAccessControl.DoorAccessRuleDeletedEvent, self).listElements()
            return elements

    class _getDoorAccessRules(Interface.Method):
        name = 'getDoorAccessRules'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent, useDefaults=False):
            _ret_ = dict([(
                elem['key'],
                raritan.rpc.smartlock.DoorAccessControl.DoorAccessRule.decode(elem['value'], agent, useDefaults=useDefaults))
                for elem in rsp['_ret_']])
            return _ret_

    class _setAllDoorAccessRules(Interface.Method):
        name = 'setAllDoorAccessRules'

        @staticmethod
        def encode(rules):
            args = {}
            args['rules'] = [dict(
                key = k,
                value = raritan.rpc.smartlock.DoorAccessControl.DoorAccessRule.encode(v))
                for k, v in rules.items()]
            return args

        @staticmethod
        def decode(rsp, agent, useDefaults=False):
            _ret_ = rsp['_ret_']
            invalidRuleIds = [x0 for x0 in rsp['invalidRuleIds']]
            typecheck.is_int(_ret_, DecodeException)
            for x0 in invalidRuleIds:
                typecheck.is_int(x0, DecodeException)
            return (_ret_, invalidRuleIds)

    class _addDoorAccessRule(Interface.Method):
        name = 'addDoorAccessRule'

        @staticmethod
        def encode(rule):
            typecheck.is_struct(rule, raritan.rpc.smartlock.DoorAccessControl.DoorAccessRule, AssertionError)
            args = {}
            args['rule'] = raritan.rpc.smartlock.DoorAccessControl.DoorAccessRule.encode(rule)
            return args

        @staticmethod
        def decode(rsp, agent, useDefaults=False):
            _ret_ = rsp['_ret_']
            ruleId = rsp['ruleId']
            typecheck.is_int(_ret_, DecodeException)
            typecheck.is_int(ruleId, DecodeException)
            return (_ret_, ruleId)

    class _modifyDoorAccessRule(Interface.Method):
        name = 'modifyDoorAccessRule'

        @staticmethod
        def encode(id, modifiedRule):
            typecheck.is_int(id, AssertionError)
            typecheck.is_struct(modifiedRule, raritan.rpc.smartlock.DoorAccessControl.DoorAccessRule, AssertionError)
            args = {}
            args['id'] = id
            args['modifiedRule'] = raritan.rpc.smartlock.DoorAccessControl.DoorAccessRule.encode(modifiedRule)
            return args

        @staticmethod
        def decode(rsp, agent, useDefaults=False):
            _ret_ = rsp['_ret_']
            typecheck.is_int(_ret_, DecodeException)
            return _ret_

    class _deleteDoorAccessRule(Interface.Method):
        name = 'deleteDoorAccessRule'

        @staticmethod
        def encode(id):
            typecheck.is_int(id, AssertionError)
            args = {}
            args['id'] = id
            return args

        @staticmethod
        def decode(rsp, agent, useDefaults=False):
            _ret_ = rsp['_ret_']
            typecheck.is_int(_ret_, DecodeException)
            return _ret_
    def __init__(self, target, agent):
        super(DoorAccessControl, self).__init__(target, agent)
        self.getDoorAccessRules = DoorAccessControl._getDoorAccessRules(self)
        self.setAllDoorAccessRules = DoorAccessControl._setAllDoorAccessRules(self)
        self.addDoorAccessRule = DoorAccessControl._addDoorAccessRule(self)
        self.modifyDoorAccessRule = DoorAccessControl._modifyDoorAccessRule(self)
        self.deleteDoorAccessRule = DoorAccessControl._deleteDoorAccessRule(self)

#
# Section generated by IdlC from "Keypad.idl"
#

import raritan.rpc
from raritan.rpc import Interface, Structure, ValueObject, Enumeration, typecheck, DecodeException
import raritan.rpc.idl

import raritan.rpc.smartlock


# interface
class Keypad(Interface):
    idlType = "smartlock.Keypad:1.0.0"

    NO_ERROR = 0

    ERR_SLOT_EMPTY = 1

    # structure
    class MetaData(Structure):
        idlType = "smartlock.Keypad.MetaData:1.0.0"
        elements = ["id", "manufacturer", "product", "serialNumber", "channel", "position"]

        def __init__(self, id="", manufacturer="", product="", serialNumber="", channel=0, position=""):
            if not typecheck._is_int(id):
                typecheck.is_string(id, AssertionError)
            if not typecheck._is_int(manufacturer):
                typecheck.is_string(manufacturer, AssertionError)
            if not typecheck._is_int(product):
                typecheck.is_string(product, AssertionError)
            if not typecheck._is_int(serialNumber):
                typecheck.is_string(serialNumber, AssertionError)
            typecheck.is_int(channel, AssertionError)
            if not typecheck._is_int(position):
                typecheck.is_string(position, AssertionError)

            self.id = id
            self.manufacturer = manufacturer
            self.product = product
            self.serialNumber = serialNumber
            self.channel = channel
            self.position = position

        @classmethod
        def decode(cls, json, agent, useDefaults=False):
            obj = cls(
                id = json['id'] if 'id' in json or not useDefaults else "",
                manufacturer = json['manufacturer'] if 'manufacturer' in json or not useDefaults else "",
                product = json['product'] if 'product' in json or not useDefaults else "",
                serialNumber = json['serialNumber'] if 'serialNumber' in json or not useDefaults else "",
                channel = json['channel'] if 'channel' in json or not useDefaults else 0,
                position = json['position'] if 'position' in json or not useDefaults else "",
            )
            return obj

        def encode(self):
            json = {}
            json['id'] = str(self.id)
            json['manufacturer'] = str(self.manufacturer)
            json['product'] = str(self.product)
            json['serialNumber'] = str(self.serialNumber)
            json['channel'] = self.channel
            json['position'] = str(self.position)
            return json

    # value object
    class PINEnteredEvent(raritan.rpc.idl.Event):
        idlType = "smartlock.Keypad.PINEnteredEvent:1.0.0"

        def __init__(self, metaData=None, source=None):
            super(raritan.rpc.smartlock.Keypad.PINEnteredEvent, self).__init__(source)
            if metaData is None:
                metaData = raritan.rpc.smartlock.Keypad.MetaData()
            typecheck.is_struct(metaData, raritan.rpc.smartlock.Keypad.MetaData, AssertionError)

            self.metaData = metaData

        def encode(self):
            json = super(raritan.rpc.smartlock.Keypad.PINEnteredEvent, self).encode()
            json['metaData'] = raritan.rpc.smartlock.Keypad.MetaData.encode(self.metaData)
            return json

        @classmethod
        def decode(cls, json, agent, useDefaults=False):
            obj = cls(
                metaData = raritan.rpc.smartlock.Keypad.MetaData.decode(json['metaData'], agent, useDefaults=useDefaults) if 'metaData' in json or not useDefaults else raritan.rpc.smartlock.Keypad.MetaData(),
                # for idl.Event
                source = Interface.decode(json['source'], agent) if 'source' in json or not useDefaults else None,
            )
            return obj

        def listElements(self):
            elements = ["metaData"]
            elements = elements + super(raritan.rpc.smartlock.Keypad.PINEnteredEvent, self).listElements()
            return elements

    class _getMetaData(Interface.Method):
        name = 'getMetaData'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent, useDefaults=False):
            _ret_ = raritan.rpc.smartlock.Keypad.MetaData.decode(rsp['_ret_'], agent, useDefaults=useDefaults)
            typecheck.is_struct(_ret_, raritan.rpc.smartlock.Keypad.MetaData, DecodeException)
            return _ret_

    class _getPIN(Interface.Method):
        name = 'getPIN'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent, useDefaults=False):
            _ret_ = rsp['_ret_']
            pin = rsp['pin']
            typecheck.is_int(_ret_, DecodeException)
            if not typecheck._is_int(pin):
                typecheck.is_string(pin, DecodeException)
            return (_ret_, pin)
    def __init__(self, target, agent):
        super(Keypad, self).__init__(target, agent)
        self.getMetaData = Keypad._getMetaData(self)
        self.getPIN = Keypad._getPIN(self)

#
# Section generated by IdlC from "KeypadManager.idl"
#

import raritan.rpc
from raritan.rpc import Interface, Structure, ValueObject, Enumeration, typecheck, DecodeException
import raritan.rpc.event

import raritan.rpc.idl

import raritan.rpc.smartlock


# interface
class KeypadManager(Interface):
    idlType = "smartlock.KeypadManager:1.0.1"

    # structure
    class KeypadSettings(Structure):
        idlType = "smartlock.KeypadManager_1_0_1.KeypadSettings:1.0.0"
        elements = ["name", "description"]

        def __init__(self, name="", description=""):
            if not typecheck._is_int(name):
                typecheck.is_string(name, AssertionError)
            if not typecheck._is_int(description):
                typecheck.is_string(description, AssertionError)

            self.name = name
            self.description = description

        @classmethod
        def decode(cls, json, agent, useDefaults=False):
            obj = cls(
                name = json['name'] if 'name' in json or not useDefaults else "",
                description = json['description'] if 'description' in json or not useDefaults else "",
            )
            return obj

        def encode(self):
            json = {}
            json['name'] = str(self.name)
            json['description'] = str(self.description)
            return json

    # value object
    class KeypadEvent(raritan.rpc.idl.Event):
        idlType = "smartlock.KeypadManager_1_0_1.KeypadEvent:1.0.0"

        def __init__(self, keypad=None, metaData=None, source=None):
            super(raritan.rpc.smartlock.KeypadManager.KeypadEvent, self).__init__(source)
            if metaData is None:
                metaData = raritan.rpc.smartlock.Keypad.MetaData()
            typecheck.is_interface(keypad, raritan.rpc.smartlock.Keypad, AssertionError)
            typecheck.is_struct(metaData, raritan.rpc.smartlock.Keypad.MetaData, AssertionError)

            self.keypad = keypad
            self.metaData = metaData

        def encode(self):
            json = super(raritan.rpc.smartlock.KeypadManager.KeypadEvent, self).encode()
            json['keypad'] = Interface.encode(self.keypad)
            json['metaData'] = raritan.rpc.smartlock.Keypad.MetaData.encode(self.metaData)
            return json

        @classmethod
        def decode(cls, json, agent, useDefaults=False):
            obj = cls(
                keypad = Interface.decode(json['keypad'], agent) if 'keypad' in json or not useDefaults else None,
                metaData = raritan.rpc.smartlock.Keypad.MetaData.decode(json['metaData'], agent, useDefaults=useDefaults) if 'metaData' in json or not useDefaults else raritan.rpc.smartlock.Keypad.MetaData(),
                # for idl.Event
                source = Interface.decode(json['source'], agent) if 'source' in json or not useDefaults else None,
            )
            return obj

        def listElements(self):
            elements = ["keypad", "metaData"]
            elements = elements + super(raritan.rpc.smartlock.KeypadManager.KeypadEvent, self).listElements()
            return elements

    # value object
    class KeypadAttachedEvent(KeypadEvent):
        idlType = "smartlock.KeypadManager_1_0_1.KeypadAttachedEvent:1.0.0"

        def __init__(self, keypad=None, metaData=None, source=None):
            super(raritan.rpc.smartlock.KeypadManager.KeypadAttachedEvent, self).__init__(keypad, metaData, source)

        def encode(self):
            json = super(raritan.rpc.smartlock.KeypadManager.KeypadAttachedEvent, self).encode()
            return json

        @classmethod
        def decode(cls, json, agent, useDefaults=False):
            obj = cls(
                # for smartlock.KeypadManager_1_0_1.KeypadEvent
                keypad = Interface.decode(json['keypad'], agent) if 'keypad' in json or not useDefaults else None,
                metaData = raritan.rpc.smartlock.Keypad.MetaData.decode(json['metaData'], agent, useDefaults=useDefaults) if 'metaData' in json or not useDefaults else raritan.rpc.smartlock.Keypad.MetaData(),
                # for idl.Event
                source = Interface.decode(json['source'], agent) if 'source' in json or not useDefaults else None,
            )
            return obj

        def listElements(self):
            elements = []
            elements = elements + super(raritan.rpc.smartlock.KeypadManager.KeypadAttachedEvent, self).listElements()
            return elements

    # value object
    class KeypadDetachedEvent(KeypadEvent):
        idlType = "smartlock.KeypadManager_1_0_1.KeypadDetachedEvent:1.0.0"

        def __init__(self, keypad=None, metaData=None, source=None):
            super(raritan.rpc.smartlock.KeypadManager.KeypadDetachedEvent, self).__init__(keypad, metaData, source)

        def encode(self):
            json = super(raritan.rpc.smartlock.KeypadManager.KeypadDetachedEvent, self).encode()
            return json

        @classmethod
        def decode(cls, json, agent, useDefaults=False):
            obj = cls(
                # for smartlock.KeypadManager_1_0_1.KeypadEvent
                keypad = Interface.decode(json['keypad'], agent) if 'keypad' in json or not useDefaults else None,
                metaData = raritan.rpc.smartlock.Keypad.MetaData.decode(json['metaData'], agent, useDefaults=useDefaults) if 'metaData' in json or not useDefaults else raritan.rpc.smartlock.Keypad.MetaData(),
                # for idl.Event
                source = Interface.decode(json['source'], agent) if 'source' in json or not useDefaults else None,
            )
            return obj

        def listElements(self):
            elements = []
            elements = elements + super(raritan.rpc.smartlock.KeypadManager.KeypadDetachedEvent, self).listElements()
            return elements

    # value object
    class KeypadSettingsChangedEvent(raritan.rpc.event.UserEvent):
        idlType = "smartlock.KeypadManager_1_0_1.KeypadSettingsChangedEvent:1.0.0"

        def __init__(self, keypad=None, oldSettings=None, newSettings=None, position="", actUserName="", actIpAddr="", source=None):
            super(raritan.rpc.smartlock.KeypadManager.KeypadSettingsChangedEvent, self).__init__(actUserName, actIpAddr, source)
            if oldSettings is None:
                oldSettings = raritan.rpc.smartlock.KeypadManager.KeypadSettings()
            if newSettings is None:
                newSettings = raritan.rpc.smartlock.KeypadManager.KeypadSettings()
            typecheck.is_interface(keypad, raritan.rpc.smartlock.Keypad, AssertionError)
            typecheck.is_struct(oldSettings, raritan.rpc.smartlock.KeypadManager.KeypadSettings, AssertionError)
            typecheck.is_struct(newSettings, raritan.rpc.smartlock.KeypadManager.KeypadSettings, AssertionError)
            if not typecheck._is_int(position):
                typecheck.is_string(position, AssertionError)

            self.keypad = keypad
            self.oldSettings = oldSettings
            self.newSettings = newSettings
            self.position = position

        def encode(self):
            json = super(raritan.rpc.smartlock.KeypadManager.KeypadSettingsChangedEvent, self).encode()
            json['keypad'] = Interface.encode(self.keypad)
            json['oldSettings'] = raritan.rpc.smartlock.KeypadManager.KeypadSettings.encode(self.oldSettings)
            json['newSettings'] = raritan.rpc.smartlock.KeypadManager.KeypadSettings.encode(self.newSettings)
            json['position'] = str(self.position)
            return json

        @classmethod
        def decode(cls, json, agent, useDefaults=False):
            obj = cls(
                keypad = Interface.decode(json['keypad'], agent) if 'keypad' in json or not useDefaults else None,
                oldSettings = raritan.rpc.smartlock.KeypadManager.KeypadSettings.decode(json['oldSettings'], agent, useDefaults=useDefaults) if 'oldSettings' in json or not useDefaults else raritan.rpc.smartlock.KeypadManager.KeypadSettings(),
                newSettings = raritan.rpc.smartlock.KeypadManager.KeypadSettings.decode(json['newSettings'], agent, useDefaults=useDefaults) if 'newSettings' in json or not useDefaults else raritan.rpc.smartlock.KeypadManager.KeypadSettings(),
                position = json['position'] if 'position' in json or not useDefaults else "",
                # for event.UserEvent
                actUserName = json['actUserName'] if 'actUserName' in json or not useDefaults else "",
                actIpAddr = json['actIpAddr'] if 'actIpAddr' in json or not useDefaults else "",
                # for idl.Event
                source = Interface.decode(json['source'], agent) if 'source' in json or not useDefaults else None,
            )
            return obj

        def listElements(self):
            elements = ["keypad", "oldSettings", "newSettings", "position"]
            elements = elements + super(raritan.rpc.smartlock.KeypadManager.KeypadSettingsChangedEvent, self).listElements()
            return elements

    class _getKeypads(Interface.Method):
        name = 'getKeypads'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent, useDefaults=False):
            _ret_ = [Interface.decode(x0, agent) for x0 in rsp['_ret_']]
            for x0 in _ret_:
                typecheck.is_interface(x0, raritan.rpc.smartlock.Keypad, DecodeException)
            return _ret_

    class _getKeypadById(Interface.Method):
        name = 'getKeypadById'

        @staticmethod
        def encode(keypadId):
            if not typecheck._is_int(keypadId):
                typecheck.is_string(keypadId, AssertionError)
            args = {}
            args['keypadId'] = str(keypadId)
            return args

        @staticmethod
        def decode(rsp, agent, useDefaults=False):
            _ret_ = Interface.decode(rsp['_ret_'], agent)
            typecheck.is_interface(_ret_, raritan.rpc.smartlock.Keypad, DecodeException)
            return _ret_

    class _setKeypadSettings(Interface.Method):
        name = 'setKeypadSettings'

        @staticmethod
        def encode(position, setting):
            if not typecheck._is_int(position):
                typecheck.is_string(position, AssertionError)
            typecheck.is_struct(setting, raritan.rpc.smartlock.KeypadManager.KeypadSettings, AssertionError)
            args = {}
            args['position'] = str(position)
            args['setting'] = raritan.rpc.smartlock.KeypadManager.KeypadSettings.encode(setting)
            return args

        @staticmethod
        def decode(rsp, agent, useDefaults=False):
            _ret_ = rsp['_ret_']
            typecheck.is_int(_ret_, DecodeException)
            return _ret_

    class _getAllKeypadSettings(Interface.Method):
        name = 'getAllKeypadSettings'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent, useDefaults=False):
            _ret_ = dict([(
                elem['key'],
                raritan.rpc.smartlock.KeypadManager.KeypadSettings.decode(elem['value'], agent, useDefaults=useDefaults))
                for elem in rsp['_ret_']])
            return _ret_
    def __init__(self, target, agent):
        super(KeypadManager, self).__init__(target, agent)
        self.getKeypads = KeypadManager._getKeypads(self)
        self.getKeypadById = KeypadManager._getKeypadById(self)
        self.setKeypadSettings = KeypadManager._setKeypadSettings(self)
        self.getAllKeypadSettings = KeypadManager._getAllKeypadSettings(self)
