/*
 * Decompiled with CFR 0.152.
 */
package rene.zirkel.graphics;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.datatransfer.Clipboard;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.text.AttributedCharacterIterator;
import java.util.Hashtable;
import rene.zirkel.graphics.EpsFontMetrics;
import rene.zirkel.graphics.EpsPoint;

public class EPSGraphics {
    private Color _currentColor = Color.black;
    private Font _currentFont;
    private double _width;
    private double _height;
    int _orientation;
    private Hashtable _linepattern = new Hashtable();
    private OutputStream _out;
    private StringBuffer _buffer = new StringBuffer();
    private Clipboard _clipboard;
    private double LineWidth = 1.0;
    private static String[] _patterns = new String[]{"[]", "[1 1]", "[4 4]", "[4 4 1 4]", "[2 2]", "[4 2 1 2 1 2]", "[5 3 2 3]", "[3 3]", "[4 2 1 2 2 2]", "[1 2 5 2 1 2 1 2]", "[4 1 2 1]"};
    private int _patternIndex = 0;
    public static final int PORTRAIT = 0;
    public static final int LANDSCAPE = 1;
    private FontMetrics FM;

    public EPSGraphics(OutputStream outputStream, double d2, double d3, int n, boolean bl) {
        this._width = d2;
        this._height = d3;
        this._orientation = n;
        this._out = outputStream;
        this._buffer.append("%!PS-Adobe-3.0 EPSF-3.0\n");
        this._buffer.append("%%Creator: QCircuitBuilder\n");
        this._buffer.append("%%BoundingBox: 50 50 " + (int)(50.0 + d2) + " " + (int)(50.0 + d3) + "\n");
        this._buffer.append("%%Pages: 1\n");
        this._buffer.append("%%Page: 1 1\n");
        this._buffer.append("%%LanguageLevel: 2\n");
        if (bl) {
            this.clipRect(0.0, 0.0, d2, d3);
        }
        this._buffer.append("/Helvetica findfont 10 scalefont setfont\n");
    }

    public void clearRect(int n, int n2, int n3, int n4) {
    }

    public void clipRect(double d2, double d3, double d4, double d5) {
        EpsPoint epsPoint = this._convert(d2, d3);
        this._buffer.append("newpath " + this.round(epsPoint.x) + " " + this.round(epsPoint.y) + " moveto\n");
        this._buffer.append("0 " + this.round(-d5) + " rlineto\n");
        this._buffer.append("" + this.round(d4) + " 0 rlineto\n");
        this._buffer.append("0 " + this.round(d5) + " rlineto\n");
        this._buffer.append("" + this.round(-d4) + " 0 rlineto\n");
        this._buffer.append("closepath clip\n");
    }

    private double round(double d2) {
        return (double)Math.round(d2 * 1000.0) / 1000.0;
    }

    public void drawLine(double d2, double d3, double d4, double d5) {
        EpsPoint epsPoint = this._convert(d2, d3);
        EpsPoint epsPoint2 = this._convert(d4, d5);
        this._buffer.append("newpath " + this.round(epsPoint.x) + " " + this.round(epsPoint.y) + " moveto\n");
        this._buffer.append("" + this.round(epsPoint2.x) + " " + this.round(epsPoint2.y) + " lineto\n");
        this._buffer.append("stroke\n");
    }

    public void drawPolygon(double[] dArray, double[] dArray2, int n) {
        if (!this._polygon(dArray, dArray2, n)) {
            return;
        }
        this._buffer.append("closepath stroke\n");
    }

    public void drawOval(double d2, double d3, double d4, double d5) {
        double d6 = d4 / 2.0;
        this._buffer.append("newpath " + this._convertX(d2 + d6) + " " + this._convertY(d3 + d6) + " " + this.round(d6) + " 0 360 arc closepath stroke\n");
    }

    public void drawRect(double d2, double d3, double d4, double d5) {
        EpsPoint epsPoint = this._convert(d2, d3);
        this._buffer.append("newpath " + this.round(epsPoint.x) + " " + this.round(epsPoint.y) + " moveto\n");
        this._buffer.append("0 " + this.round(-d5) + " rlineto\n");
        this._buffer.append("" + this.round(d4) + " 0 rlineto\n");
        this._buffer.append("0 " + this.round(d5) + " rlineto\n");
        this._buffer.append("" + this.round(-d4) + " 0 rlineto\n");
        this._buffer.append("closepath stroke\n");
    }

    public void drawRoundRect(double d2, double d3, double d4, double d5, int n, int n2) {
    }

    public void drawString(AttributedCharacterIterator attributedCharacterIterator, int n, int n2) {
    }

    public void drawString(String string, double d2, double d3) {
        FontMetrics fontMetrics = this.getFontMetrics();
        EpsPoint epsPoint = this._convert(d2, d3);
        this._buffer.append("" + epsPoint.x + " " + epsPoint.y + " moveto\n");
        this._buffer.append("(" + string + ") show\n");
    }

    public void drawArc(double d2, double d3, double d4, double d5, double d6, double d7) {
        double d8 = d4 / 2.0;
        this._buffer.append("newpath " + this._convertX(d2 + d8) + " " + this._convertY(d3 + d8) + " " + this.round(d8) + " " + this.round(d6) + " " + " " + this.round(d6 + d7) + " arc stroke\n");
    }

    public void fillArc(double d2, double d3, double d4, double d5, double d6, double d7) {
        double d8 = d4 / 2.0;
        this._buffer.append("newpath " + this._convertX(d2 + d8) + " " + this._convertY(d3 + d8) + " " + " moveto " + this._convertX(d2 + d8) + " " + this._convertY(d3 + d8) + " " + d8 + " " + this.round(d6) + " " + this.round(d6 + d7) + " arc closepath fill\n");
    }

    public void fillChord(double d2, double d3, double d4, double d5, double d6, double d7) {
        double d8 = d4 / 2.0;
        this._buffer.append("newpath " + this._convertX(d2 + d8) + " " + this._convertY(d3 + d8) + " " + this.round(d8) + " " + this.round(d6) + " " + this.round(d6 + d7) + " arc fill\n");
    }

    public void fillPolygon(double[] dArray, double[] dArray2, int n) {
        if (!this._polygon(dArray, dArray2, n)) {
            return;
        }
        this._buffer.append("closepath fill\n");
    }

    public void fillOval(double d2, double d3, double d4, double d5) {
        double d6 = d4 / 2.0;
        this._buffer.append("newpath " + this._convertX(d2 + d6) + " " + this._convertY(d3 + d6) + " " + d6 + " 0 360 arc closepath fill\n");
    }

    public void fillRect(double d2, double d3, double d4, double d5) {
        EpsPoint epsPoint = this._convert(d2, d3);
        this._buffer.append("newpath " + epsPoint.x + " " + epsPoint.y + " moveto\n");
        this._buffer.append("0 " + this.round(-d5) + " rlineto\n");
        this._buffer.append("" + this.round(d4) + " 0 rlineto\n");
        this._buffer.append("0 " + this.round(d5) + " rlineto\n");
        this._buffer.append("" + this.round(-d4) + " 0 rlineto\n");
        this._buffer.append("closepath gsave fill grestore\n");
        this._buffer.append("0.5 setlinewidth 0 setgray [] 0 setdash stroke\n");
        this._buffer.append(this.round(this.LineWidth) + " setlinewidth\n");
    }

    public void fillRoundRect(double d2, double d3, double d4, double d5, int n, int n2) {
    }

    public Shape getClip() {
        return null;
    }

    public Rectangle getClipBounds() {
        return null;
    }

    public Color getColor() {
        return this._currentColor;
    }

    public Font getFont() {
        return this._currentFont;
    }

    public FontMetrics getFontMetrics(Font font) {
        if (this.FM == null) {
            this.FM = new EpsFontMetrics(new Font("dialog", 0, 20));
        }
        return this.FM;
    }

    public FontMetrics getFontMetrics() {
        return this.getFontMetrics(this._currentFont);
    }

    public void setFont(Font font) {
        int n = font.getSize();
        boolean bl = font.isBold();
        if (bl) {
            this._buffer.append("/Helvetica-Bold findfont\n");
        } else {
            this._buffer.append("/Helvetica findfont\n");
        }
        this._buffer.append("" + n + " scalefont setfont\n");
        this._currentFont = font;
        this.FM = new EpsFontMetrics(font);
    }

    public void setClip(Shape shape) {
    }

    public void setClip(int n, int n2, int n3, int n4) {
    }

    public void setColor(Color color) {
        this._buffer.append((double)color.getRed() / 255.0);
        this._buffer.append(" ");
        this._buffer.append((double)color.getGreen() / 255.0);
        this._buffer.append(" ");
        this._buffer.append((double)color.getBlue() / 255.0);
        this._buffer.append(" setrgbcolor\n");
        this._currentColor = color;
    }

    public void setLineWidth(double d2) {
        this._buffer.append(this.round(d2) + " setlinewidth\n");
        this.LineWidth = d2;
    }

    public void setDash(double d2, double d3) {
        this._buffer.append("[" + this.round(d2) + " " + this.round(d3) + " ] 0 setdash\n");
    }

    public void clearDash() {
        this._buffer.append("[ ] 0 setdash\n");
    }

    public void setPaintMode() {
    }

    public void setXORMode(Color color) {
    }

    public void showpage(String string) {
        try {
            this._buffer.append("%%EOF");
            PrintWriter printWriter = new PrintWriter(new FileWriter(string));
            printWriter.println(this._buffer.toString());
            printWriter.flush();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void close() throws IOException {
        this._buffer.append("showpage\n");
        this._buffer.append("%%EOF");
        PrintWriter printWriter = new PrintWriter(this._out);
        printWriter.println(this._buffer.toString());
        printWriter.flush();
    }

    private EpsPoint _convert(double d2, double d3) {
        return new EpsPoint(this.round(d2 + 50.0), this.round(this._height + 50.0 - d3));
    }

    private double _convertX(double d2) {
        return this.round(d2 + 50.0);
    }

    private double _convertY(double d2) {
        return this.round(this._height + 50.0 - d2);
    }

    private boolean _polygon(double[] dArray, double[] dArray2, int n) {
        if (n < 3 || dArray.length < n || dArray2.length < n) {
            return false;
        }
        EpsPoint epsPoint = this._convert(dArray[0], dArray2[0]);
        this._buffer.append("newpath " + this.round(epsPoint.x) + " " + this.round(epsPoint.y) + " moveto\n");
        for (int i = 1; i < n; ++i) {
            EpsPoint epsPoint2 = this._convert(dArray[i], dArray2[i]);
            this._buffer.append("" + this.round(epsPoint2.x) + " " + this.round(epsPoint2.y) + " lineto\n");
        }
        return true;
    }

    private void _fillPattern() {
        int n = this._currentColor.getRed();
        int n2 = this._currentColor.getGreen();
        int n3 = this._currentColor.getBlue();
        double d2 = 0.6;
        double d3 = 0.8;
        double d4 = 1.0;
        double d5 = Math.sqrt(65025.0 * (d2 * d2 + d3 * d3 + d4 * d4));
        double d6 = Math.sqrt((double)(n * n) * d3 * d3 + (double)(n3 * n3) * d2 * d2 + (double)(n2 * n2) * d4 * d4) / d5;
        this._buffer.append("" + d6 + " setgray\n");
        this._buffer.append("rgb: " + n + " " + n2 + " " + n3 + "\n");
    }
}

